"""
Inset
=====

The :meth:`pygmt.Figure.inset` method adds an inset figure inside a larger figure. The
method is called using a ``with`` statement. Plotting methods called within the ``with``
statement are applied to the inset figure.
"""

# %%
import pygmt
from pygmt.params import Box, Position

fig = pygmt.Figure()
# Create the primary figure, setting the region to Madagascar, the land color to
# "brown", the water to "lightblue", the shorelines width to "thin", and adding a frame
fig.coast(region="MG+r2", land="brown", water="lightblue", shorelines="thin", frame="a")
# Create an inset, placing it in the Top Left (TL) corner with a width of 3.5 cm and
# x- and y-offsets of 0.2 cm. The clearance is set to 0, and the border is "gold" with a
# pen thickness of 1.5 points.
with fig.inset(
    position=Position("TL", offset=0.2),
    width=3.5,
    clearance=0,
    box=Box(pen="1.5p,gold"),
):
    # Create a figure in the inset using coast. This example uses the azimuthal
    # orthogonal projection centered at 47E, 20S. The land color is set to "gray" and
    # Madagascar is highlighted in "red3".
    fig.coast(
        region="g", projection="G47/-20/?", land="gray", water="white", dcw="MG+gred3"
    )
fig.show()
